/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.Button;
import control.EndControl;
import control.MenuControl;
import control.SoundControl;
import data.ColorArrangement;
import data.Constants;
import org.lwjgl.opengl.GL11;
import view.Fonts;
import view.StaticDrawer;
import view.UserInput;

public class EndView {
    private static float screenAdjust = -2 * Constants.VIEW_WIDTH - 200;
    private UserInput Ui = new UserInput();
    private SoundControl soundController;
    float wipeOffset;
    int drawOffset;
    public int thisScoreIncrement;
    public int thisTimeIncrement;
    public float timeSpace;
    public float yScale;
    public float xScale;
    Button returnToMenu;
    Button viewGraph;

    public EndView(ColorArrangement colorArrangement, SoundControl soundController) {
        this.soundController = soundController;
        this.wipeOffset = 0.0f;
        this.drawOffset = 0;
        this.returnToMenu = new Button(Constants.VIEW_WIDTH - (int)(100.0f * Fonts.resolutionScale) + (int)screenAdjust, Constants.VIEW_HEIGHT * 1 / 2, "High Scores", 0.75f);
        this.viewGraph = new Button(Constants.VIEW_WIDTH + (int)(Fonts.getWidth("Score Graph", 0.75) / 2.0f + 55.0f * Fonts.resolutionScale) + (int)screenAdjust, Constants.VIEW_HEIGHT * 1 / 2, "Score Graph", 0.75f);
        this.xScale = ((float)this.returnToMenu.xLoc - screenAdjust - this.returnToMenu.getButtonWidth() / 2.0f) / (float)Constants.VIEW_WIDTH;
        int i = 0;
        while (i < ColorArrangement.iScoreArray.length) {
            if (ColorArrangement.iScoreArray[i] == -1) {
                ColorArrangement.iScoreArray[i] = i == 0 ? 0 : ColorArrangement.iScoreArray[i - 1];
            }
            ++i;
        }
    }

    public void draw(float offX, float offY) {
        this.returnToMenu.draw();
        this.viewGraph.draw();
        GL11.glPushMatrix();
        GL11.glTranslatef(offX, offY, 0.0f);
        Fonts.drawText((int)((float)(Constants.VIEW_WIDTH / 2) + screenAdjust), Constants.VIEW_HEIGHT / 8, 1.0, String.valueOf(Constants.SONG_TO_USE.substring(0, Constants.SONG_TO_USE.length() - 4)) + ": " + Integer.toString(Constants.SCORE), true);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 1);
        GL11.glPushMatrix();
        GL11.glTranslatef(screenAdjust, Constants.VIEW_HEIGHT * 3 / 4, 0.0f);
        int i = 0;
        while ((float)i <= (float)(Constants.VIEW_HEIGHT / 2) / ((float)this.thisScoreIncrement * this.yScale)) {
            GL11.glBegin(1);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.04f);
            GL11.glVertex2f(0.0f, (float)(-i) * ((float)this.thisScoreIncrement * this.yScale));
            GL11.glVertex2f((float)Constants.VIEW_WIDTH * this.xScale, (float)(-i) * ((float)this.thisScoreIncrement * this.yScale));
            GL11.glEnd();
            ++i;
        }
        i = 0;
        while ((float)i <= (float)Constants.VIEW_WIDTH * this.xScale / this.timeSpace + 1.0f) {
            GL11.glBegin(3);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
            GL11.glVertex2f((float)i * this.timeSpace * this.xScale, Constants.blockSize * 2);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.04f);
            GL11.glVertex2f((float)i * this.timeSpace * this.xScale, 0.0f);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.04f);
            GL11.glVertex2f((float)i * this.timeSpace * this.xScale, -Constants.VIEW_HEIGHT / 2);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
            GL11.glVertex2f((float)i * this.timeSpace * this.xScale, -(Constants.VIEW_HEIGHT / 2 + Constants.blockSize * 2));
            GL11.glEnd();
            ++i;
        }
        GL11.glPopMatrix();
        GL11.glDisable(3042);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 1);
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f + screenAdjust, Constants.VIEW_HEIGHT * 3 / 4, 0.0f);
        GL11.glScalef(1.0f, this.yScale, 1.0f);
        GL11.glBegin(5);
        float[] colors = StaticDrawer.getColorValues(ColorArrangement.iBandArray[0], ColorArrangement.fSaturationArray[0], true);
        int i2 = 0;
        while (i2 < this.drawOffset) {
            colors = ColorArrangement.iBandArray[i2] == -1 ? new float[]{1.0f, 1.0f, 1.0f} : StaticDrawer.getColorValues(ColorArrangement.iBandArray[i2], ColorArrangement.fSaturationArray[i2], true);
            GL11.glColor4f(colors[0], colors[1], colors[2], 0.1f);
            GL11.glVertex2f(i2, -ColorArrangement.iScoreArray[i2]);
            GL11.glColor4f(colors[0], colors[1], colors[2], 0.7f);
            GL11.glVertex2f(i2, 0.0f);
            ++i2;
        }
        GL11.glEnd();
        GL11.glBegin(3);
        i2 = 0;
        while (i2 < this.drawOffset) {
            GL11.glColor4f(1.0f, 1.0f, 1.0f, (float)i2 / (float)this.drawOffset / 2.0f + 0.05f);
            GL11.glVertex2f(i2, -ColorArrangement.iScoreArray[i2]);
            ++i2;
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(25.0f * Fonts.resolutionScale + screenAdjust, Constants.VIEW_HEIGHT * 3 / 4, 0.0f);
        if (this.yScale == 1.0f) {
            i2 = 0;
            while (i2 < Constants.VIEW_HEIGHT / 2 / this.thisScoreIncrement) {
                GL11.glTranslatef(0.0f, -((float)this.thisScoreIncrement * this.yScale), 0.0f);
                Fonts.drawText(0.0f, 0.0f, 0.5, Integer.toString(this.thisScoreIncrement * (i2 + 1)), true);
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < ColorArrangement.largestScore / this.thisScoreIncrement) {
                GL11.glTranslatef(0.0f, -((float)this.thisScoreIncrement * this.yScale), 0.0f);
                Fonts.drawText(0.0f, 0.0f, 0.5, Integer.toString(this.thisScoreIncrement * (i2 + 1)), true);
                ++i2;
            }
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-15.0f + screenAdjust, Constants.VIEW_HEIGHT * 3 / 4 + 15, 0.0f);
        i2 = 0;
        while (i2 < this.soundController.getSongLength() / 1000 / this.thisTimeIncrement) {
            GL11.glTranslatef(this.timeSpace * this.xScale, 0.0f, 0.0f);
            if (this.thisTimeIncrement * (i2 + 1) % 60 < 10) {
                Fonts.drawText(0.0f, 0.0f, 0.5, String.valueOf(Integer.toString(this.thisTimeIncrement * (i2 + 1) / 60)) + "." + Integer.toString(this.thisTimeIncrement * (i2 + 1) % 60) + "0", true);
            } else {
                Fonts.drawText(0.0f, 0.0f, 0.5, String.valueOf(Integer.toString(this.thisTimeIncrement * (i2 + 1) / 60)) + "." + Integer.toString(this.thisTimeIncrement * (i2 + 1) % 60), true);
            }
            ++i2;
        }
        GL11.glPopMatrix();
        GL11.glBlendFunc(770, 771);
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f + screenAdjust, this.wipeOffset, 0.0f);
        GL11.glBegin(5);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glVertex2f(0.0f, Constants.VIEW_HEIGHT);
        GL11.glVertex2f(Constants.VIEW_WIDTH, Constants.VIEW_HEIGHT);
        GL11.glVertex2f(0.0f, 0.0f);
        GL11.glVertex2f(Constants.VIEW_WIDTH, 0.0f);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, 0.0f);
        GL11.glVertex2f(0.0f, -Constants.VIEW_HEIGHT);
        GL11.glVertex2f(Constants.VIEW_WIDTH, -Constants.VIEW_HEIGHT);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glDisable(3042);
        GL11.glPopMatrix();
    }

    public boolean update(float offsetX, float offsetY) {
        if (this.wipeOffset < (float)(Constants.VIEW_WIDTH * 2)) {
            this.wipeOffset += 35.0f;
            EndControl.move = true;
        } else if ((float)this.drawOffset < (float)(ColorArrangement.iScoreArray.length * 49 / 50) * this.xScale && this.Ui.getScoreEntered()) {
            this.drawOffset = (int)((float)this.drawOffset + (float)(ColorArrangement.iScoreArray.length / 50) * this.xScale);
        }
        if (MenuControl.offsetX < (float)(Constants.VIEW_WIDTH * 4 / 6)) {
            Constants.currentGameState = 0;
            EndControl.updateScoreEntered(false);
            return false;
        }
        this.Ui.update();
        EndControl.updateScoreEntered(this.Ui.getScoreEntered());
        if (!this.Ui.getScoreEntered()) {
            Fonts.drawText((float)(Constants.VIEW_WIDTH * 100 / 800) + MenuControl.offsetX + (float)((int)screenAdjust), Constants.VIEW_HEIGHT * 300 / 600 + (int)MenuControl.offsetY, 0.5, "Enter Name: ", false);
            Fonts.drawText((float)(Constants.VIEW_WIDTH * 100 / 800) + 140.0f * Fonts.resolutionScale + MenuControl.offsetX + (float)((int)screenAdjust), Constants.VIEW_HEIGHT * 300 / 600 + (int)MenuControl.offsetY, 0.5, this.Ui.getUserName(), false);
        }
        return true;
    }
}

